<nav class="navbar navbar-default" role="navigation">
	<div class="container-fluid">
        <?php if (Auth::instance()->get_user()->hasAction('Logpost')) : ?>
		<div class="navbar-header">
			<a class="navbar-brand" href="/">
				<span class="glyphicon glyphicon-home"></span>
			</a>
		</div>
        <?php endif; ?>

		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
			<ul class="nav navbar-nav">
                <?php $menuLeftsideActions = array('Logpost', 'Insert/Blacklist', 'Serverstats', 'Luhn', 'Email', 'Logpost/Mini'); ?>
                <?php foreach($menuLeftsideActions as $menuLeftsideAction) : ?><?php
                    foreach ( $actions as $action ) : ?><?php
                        if ( $action->name == $menuLeftsideAction && Auth::instance()->get_user()->hasAction($action) ) : ?>
                            <li<?php if ( '/' . UTF8::strtolower($action->name) == preg_replace('/^\/$/', '/logpost', $_SERVER['REQUEST_URI']) || 0 === strpos($_SERVER['REQUEST_URI'], '/' . UTF8::strtolower($action->name) . '/') ) : ?> class="active"<?php endif; ?>>
                                <a href="/<?= UTF8::strtolower(preg_replace('/^Logpost$/', '', $action->name)); ?>"><?= $action->menu_title; ?></a>
                            </li><?php
                        endif; ?><?php
                    endforeach; ?><?php
                endforeach; ?>
			</ul>
			<ul class="nav navbar-nav pull-right">
				<li class="divider-vertical"></li>
				<p ng-controller="utcTimer" class="navbar-text myUTCTimer"></p>
				<li>
					<a href="/login/logout"><span class="glyphicon glyphicon-log-out" style="margin-right: 4px;"></span>Logout (<?= $user->username; ?>)</a>
				</li>
			</ul>
			<ul class="nav navbar-nav navbar-right">
                <?php $menuRightsideActions = array('Roles', 'Myqueries'); ?>
                <?php foreach ( $actions as $action ) : ?><?php
                    if ( Auth::instance()->get_user()->hasAction($action) && in_array($action->name, $menuRightsideActions) ) : ?>
                        <li<?php if ( '/' . UTF8::strtolower($action->name) == $_SERVER['REQUEST_URI'] || 0 === strpos($_SERVER['REQUEST_URI'], '/' . UTF8::strtolower($action->name) . '/') ) : ?> class="active"<?php endif; ?>>
                            <a href="/<?= UTF8::strtolower($action->name); ?>"><?= $action->description; ?></a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
			</ul>

            <!-- Users -->
            <?php $menuUsers = array('Users', 'Logs'); ?>
            <?php if ( Auth::instance()->get_user()->hasAnyOfActions($menuUsers) ) : ?>
                <ul class="nav navbar-nav pull-right">
                    <li class="dropdown<?php
                    if ( in_array(substr($_SERVER['REQUEST_URI'], 1), array_map(array('UTF8', 'strtolower'), $menuUsers))
                            || preg_match('/^\/(?:' . implode('|', array_map(function($value) { return UTF8::strtolower(preg_quote($value, '/')); }, $menuUsers)) . ')\//', $_SERVER['REQUEST_URI']) ) :
                            ?> active<?php
                    endif;
                    ?>">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">Users<span class="caret"></span></a>
                        <ul class="dropdown-menu" role="menu">
                            <?php foreach ( $actions as $action ) : ?><?php
                                if ( Auth::instance()->get_user()->hasAction($action) && in_array($action->name, $menuUsers) ) : ?>
                                    <li<?php if ( '/' . UTF8::strtolower($action->name) == $_SERVER['REQUEST_URI'] || 0 === strpos($_SERVER['REQUEST_URI'], '/' . UTF8::strtolower($action->name) . '/') ) : ?> class="active"<?php endif; ?>>
                                        <a href="/<?= UTF8::strtolower($action->name); ?>"><?= $action->description; ?></a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </li>
                </ul>
            <?php endif; ?>
		</div>
	</div>
</nav>

<script type="text/javascript">
	app.controller('utcTimer', function($scope, $http, $interval){
		$scope.updUtcTimer = function(){
			$http.get('/rest/utc_timer').then(function(data){
				$('.myUTCTimer').text(data.data);
			});
		};

		$scope.updUtcTimer();
		$interval($scope.updUtcTimer, 60 * 1000);
	});
</script>